class TGEI_AutoTabs
{
  static init()
  {
    let tabs = document.querySelectorAll('.tgei-auto-tabs-tab');
    if(tabs !== undefined)
    {
      for(let i = 0; i < tabs.length; i++)
      {
        tabs[i].addEventListener("click", 
          (e) => {
          e.preventDefault();
          //window.location.hash = e.target.hash;
          TGEI_AutoTabs.setActiveTab(e.target.getAttribute("data-hash"));
          }
        );
      }
      TGEI_AutoTabs.setActiveTab();
    }
  }

  static setActiveTab(hash = null)
  {
    console.log("set active tab");
    let formerActiveTab = document.getElementsByClassName("tgei-auto-tabs-tab-active");
    if(formerActiveTab !== undefined)
    {
      for(let i = 0; i < formerActiveTab.length; i++)
      {
        formerActiveTab[i].classList.remove("tgei-auto-tabs-tab-active");
      }
    }
    let formerActiveContent = document.getElementsByClassName("tgei-auto-tabs-content-active");
    if(formerActiveContent !== undefined)
    {
      for(let i = 0; i < formerActiveContent.length; i++)
      {
        formerActiveContent[i].classList.remove("tgei-auto-tabs-content-active");
      }
    }
    if(hash !== null && hash !== "")
    {
      let activeTab = document.querySelector('.tgei-auto-tabs-tab[data-hash="' + hash + '"]');
      let activeContent = document.getElementById(hash.substr(1)); // remove the # from hash
      if(activeTab !== null)
      {
        activeTab.classList.add("tgei-auto-tabs-tab-active");
        activeContent.classList.add("tgei-auto-tabs-content-active");
        return 1;
      }
    }
    let activeTab = document.getElementsByClassName("tgei-auto-tabs-tab");
    let activeContent = document.getElementById("tab-0").classList.add("tgei-auto-tabs-content-active");
    activeTab[0].classList.add("tgei-auto-tabs-tab-active");
    return 2;
  }
}
TGEI_AutoTabs.init();
